// Wikipedia̋LǗ邽߂̃NX
#ifndef WikipediaArticleH
#define WikipediaArticleH

#include "stdafx.h"

namespace wpts {

	using namespace System;
	using namespace System::IO;
	using namespace System::Net;
	using namespace System::Xml;
	using namespace System::Windows::Forms;

	// Wikipedia̋L̏߂̃NX
	ref class WikipediaFormat {
	public:
		// WikipediãN̗vfi[邽߂̍\
		value struct Link {
			String ^Text;				// ÑeLXgi[[`]]j
			String ^Article;			// N̋L
			String ^Section;			// ÑZNVi#j
			array<String^> ^PipeTexts;	// ÑpCv̕i|j
			String ^Code;				// Ԃ܂͑vWFNgւ̃N̏ꍇAR[h
			bool TemplateFlag;			// ev[gi{{`}}jtO
			bool SubPageFlag;			// L̐擪 / Ŏn܂邩tO
			bool StartColonFlag;		// N̐擪 : Ŏn܂邩tO
			bool MsgnwFlag;				// ev[g̏ꍇAmsgnw: tĂ邩tO
			bool EnterFlag;				// ev[g̏ꍇAĽŉs邩tO

			// 
			void Initialize(void);
			// ݂TextȊO̒lAText𐶐
			String^ MakeText(void);
		};

		// RXgN^iT[o[wj
		WikipediaFormat(WikipediaInformation^);
		// fXgN^
		virtual ~WikipediaFormat(){}

		// nꂽLJeS[`FbN
		virtual bool IsCategory(String^);
		// nꂽL摜`FbN
		virtual bool IsImage(String^);
		// nꂽLWOԈȊO`FbN
		virtual bool IsNotMainNamespace(String^);

		// nꂽWikipedia̓NEev[g
		virtual Link ParseInnerLink(String^);
		virtual Link ParseTemplate(String^);
		// nꂽeLXg̎w肳ꂽʒuɑ݂Wikipedia̓NEev[g`FbN
		int ChkLinkText(Link %, String^, int);

		// nꂽeLXg̎w肳ꂽʒuɑ݂ϐ`FbN
		virtual int ChkVariable(String^ %, String^ %, String^, int);
		// nꂽeLXg̎w肳ꂽʒunowikiԂ̃`FbN
		static int ChkNowiki(String^ %, String^, int);
		// nꂽeLXg̎w肳ꂽʒuRgԂ̃`FbN
		static int ChkComment(String^ %, String^, int);

		// WikipediǎŒl̏
		static const String ^COMMENTSTART = "<!--";
		static const String ^COMMENTEND = "-->";
		static const String ^NOWIKISTART = "<nowiki>";
		static const String ^NOWIKIEND = "</nowiki>";
		static const String ^MSGNW = "msgnw:";

		// LT[o[
		property WikipediaInformation ^Server {
			WikipediaInformation^ get()
			{
				return _Server;
			}
		}

	protected:
		// LT[o[ipropertyj
		WikipediaInformation ^_Server;
	};

	// Wikipedia̋LǗ邽߂̃NX
	ref class WikipediaArticle : WikipediaFormat {
	public:
		// RXgN^iT[o[ƋLwj
		WikipediaArticle(WikipediaInformation ^i_Server, String ^i_Name)
			: WikipediaFormat(i_Server){
			// ݒ
			Initialize(i_Name);
		}
		// fXgN^
		virtual ~WikipediaArticle(){}

		// ݒ
		void Initialize(String^);

		// LT[o[擾
		// GetInterWiki(), GetNamespaces(), IsRedirect()AɑpropertýA
		//   OGetArticle()sĂKv
		virtual bool GetArticle(String^, String^, TimeSpan);
		bool GetArticle(String^, String^);
		bool GetArticle(void);
		// w肳ꂽR[hւ̌ԃNԂ
		virtual String^ GetInterWiki(String^);
		// LXML疼Oԏ擾
		virtual array<WikipediaInformation::Namespace>^ GetNamespaces(void);

		// L_CNg`FbN
		virtual bool IsRedirect(void);
		// LJeS[`FbN
		virtual bool IsCategory(void);
		// L摜`FbN
		virtual bool IsImage(void);
		// LWOԈȊO`FbN
		bool IsNotMainNamespace(void);

		// L
		property String ^Title {
			String^ get()
			{
				return _Title;
			}
		}
		// LXMLf[^URLipropertyj
		property Uri ^Url {
			Uri^ get()
			{
				return _Url;
			}
		}
		// LXMLf[^
		property XmlDocument ^Xml {
			XmlDocument^ get()
			{
				return _Xml;
			}
		}
		// L̍ŏIXViUTCj
		property DateTime Timestamp {
			DateTime get()
			{
				return _Timestamp;
			}
		}
		// L{
		property String ^Text {
			String^ get()
			{
				return _Text;
			}
		}
		// _CNgL
		property String ^Redirect {
			String^ get()
			{
				return _Redirect;
			}
		}
		// GetArticlesHttpStatus
		property HttpStatusCode GetArticleStatus {
			HttpStatusCode get()
			{
				return _GetArticleStatus;
			}
		}
		// GetArticleO̗O
		// GetArticle()falseŁAGetArticleStatusNotFoundȊÔƂAݒ肳
		property Exception ^GetArticleException {
			Exception^ get()
			{
				return _GetArticleException;
			}
		}

		// WikipediaXMĽŒl̏
		const static String ^XMLNS = "http://www.mediawiki.org/xml/export-0.3/";

	protected:
		// LXMLT[o[擾
		bool getServerArticle(String^, String^);
		// LXMLLbV擾
		bool getCacheArticle(TimeSpan);
		// L{̎w肳ꂽʒuɑ݂WikipediaLink
		virtual int chkLinkText(Link %, int);
		// L{̎w肳ꂽʒu炪RgԂ̃`FbN
		virtual int chkComment(String^ %, int);

		// Lipropertyj
		String ^_Title;
		// LXMLf[^URLipropertyj
		Uri ^_Url;
		// LXMLf[^ipropertyj
		XmlDocument ^_Xml;
		// L̍ŏIXViUTCjipropertyj
		DateTime _Timestamp;
		// L{ipropertyj
		String ^_Text;
		// _CNgLipropertyj
		String ^_Redirect;
		// GetArticlesHttpStatusipropertyj
		HttpStatusCode _GetArticleStatus;
		// GetArticleO̗Oipropertyj
		Exception ^_GetArticleException;
	};
}
#endif
